package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeResourcePolicyRequest(
    resourceArn: AmazonResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyRequest = {
    import DescribeResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DescribeResourcePolicyRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeResourcePolicyRequest
      .wrap(buildAwsValue())
}
object DescribeResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeResourcePolicyRequest =
      zio.aws.lexmodelsv2.model.DescribeResourcePolicyRequest(resourceArn)
    def resourceArn: AmazonResourceName
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyRequest
  ) extends zio.aws.lexmodelsv2.model.DescribeResourcePolicyRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.lexmodelsv2.model.primitives
        .AmazonResourceName(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyRequest
  ): zio.aws.lexmodelsv2.model.DescribeResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
