package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  DTMFCharacter,
  TimeInMilliSeconds,
  MaxUtteranceDigits
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DTMFSpecification(
    maxLength: MaxUtteranceDigits,
    endTimeoutMs: TimeInMilliSeconds,
    deletionCharacter: DTMFCharacter,
    endCharacter: DTMFCharacter
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DTMFSpecification = {
    import DTMFSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DTMFSpecification
      .builder()
      .maxLength(MaxUtteranceDigits.unwrap(maxLength): Integer)
      .endTimeoutMs(TimeInMilliSeconds.unwrap(endTimeoutMs): Integer)
      .deletionCharacter(
        DTMFCharacter.unwrap(deletionCharacter): java.lang.String
      )
      .endCharacter(DTMFCharacter.unwrap(endCharacter): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DTMFSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.DTMFSpecification.wrap(buildAwsValue())
}
object DTMFSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DTMFSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DTMFSpecification =
      zio.aws.lexmodelsv2.model.DTMFSpecification(
        maxLength,
        endTimeoutMs,
        deletionCharacter,
        endCharacter
      )
    def maxLength: MaxUtteranceDigits
    def endTimeoutMs: TimeInMilliSeconds
    def deletionCharacter: DTMFCharacter
    def endCharacter: DTMFCharacter
    def getMaxLength: ZIO[Any, Nothing, MaxUtteranceDigits] =
      ZIO.succeed(maxLength)
    def getEndTimeoutMs: ZIO[Any, Nothing, TimeInMilliSeconds] =
      ZIO.succeed(endTimeoutMs)
    def getDeletionCharacter: ZIO[Any, Nothing, DTMFCharacter] =
      ZIO.succeed(deletionCharacter)
    def getEndCharacter: ZIO[Any, Nothing, DTMFCharacter] =
      ZIO.succeed(endCharacter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DTMFSpecification
  ) extends zio.aws.lexmodelsv2.model.DTMFSpecification.ReadOnly {
    override val maxLength: MaxUtteranceDigits =
      zio.aws.lexmodelsv2.model.primitives.MaxUtteranceDigits(impl.maxLength())
    override val endTimeoutMs: TimeInMilliSeconds =
      zio.aws.lexmodelsv2.model.primitives
        .TimeInMilliSeconds(impl.endTimeoutMs())
    override val deletionCharacter: DTMFCharacter =
      zio.aws.lexmodelsv2.model.primitives
        .DTMFCharacter(impl.deletionCharacter())
    override val endCharacter: DTMFCharacter =
      zio.aws.lexmodelsv2.model.primitives.DTMFCharacter(impl.endCharacter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DTMFSpecification
  ): zio.aws.lexmodelsv2.model.DTMFSpecification.ReadOnly = new Wrapper(impl)
}
