package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Name, SubSlotExpression}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubSlotSetting(
    expression: Optional[SubSlotExpression] = Optional.Absent,
    slotSpecifications: Optional[
      Map[Name, zio.aws.lexmodelsv2.model.Specifications]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SubSlotSetting = {
    import SubSlotSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SubSlotSetting
      .builder()
      .optionallyWith(
        expression.map(value =>
          SubSlotExpression.unwrap(value): java.lang.String
        )
      )(_.expression)
      .optionallyWith(
        slotSpecifications.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.slotSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SubSlotSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.SubSlotSetting.wrap(buildAwsValue())
}
object SubSlotSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SubSlotSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SubSlotSetting =
      zio.aws.lexmodelsv2.model.SubSlotSetting(
        expression.map(value => value),
        slotSpecifications.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def expression: Optional[SubSlotExpression]
    def slotSpecifications
        : Optional[Map[Name, zio.aws.lexmodelsv2.model.Specifications.ReadOnly]]
    def getExpression: ZIO[Any, AwsError, SubSlotExpression] =
      AwsError.unwrapOptionField("expression", expression)
    def getSlotSpecifications: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.lexmodelsv2.model.Specifications.ReadOnly
    ]] = AwsError.unwrapOptionField("slotSpecifications", slotSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SubSlotSetting
  ) extends zio.aws.lexmodelsv2.model.SubSlotSetting.ReadOnly {
    override val expression: Optional[SubSlotExpression] = zio.aws.core.internal
      .optionalFromNullable(impl.expression())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.SubSlotExpression(value)
      )
    override val slotSpecifications: Optional[
      Map[Name, zio.aws.lexmodelsv2.model.Specifications.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.slotSpecifications())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives
              .Name(key) -> zio.aws.lexmodelsv2.model.Specifications.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SubSlotSetting
  ): zio.aws.lexmodelsv2.model.SubSlotSetting.ReadOnly = new Wrapper(impl)
}
