package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SlotValue(
    interpretedValue: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotValue = {
    import SlotValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotValue
      .builder()
      .optionallyWith(
        interpretedValue.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.interpretedValue)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotValue.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotValue.wrap(buildAwsValue())
}
object SlotValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotValue =
      zio.aws.lexmodelsv2.model.SlotValue(interpretedValue.map(value => value))
    def interpretedValue: Optional[NonEmptyString]
    def getInterpretedValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("interpretedValue", interpretedValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotValue
  ) extends zio.aws.lexmodelsv2.model.SlotValue.ReadOnly {
    override val interpretedValue: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interpretedValue())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotValue
  ): zio.aws.lexmodelsv2.model.SlotValue.ReadOnly = new Wrapper(impl)
}
