package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Value
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SampleValue(value: Value) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SampleValue = {
    import SampleValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SampleValue
      .builder()
      .value(Value.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SampleValue.ReadOnly =
    zio.aws.lexmodelsv2.model.SampleValue.wrap(buildAwsValue())
}
object SampleValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SampleValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SampleValue =
      zio.aws.lexmodelsv2.model.SampleValue(value)
    def value: Value
    def getValue: ZIO[Any, Nothing, Value] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SampleValue
  ) extends zio.aws.lexmodelsv2.model.SampleValue.ReadOnly {
    override val value: Value =
      zio.aws.lexmodelsv2.model.primitives.Value(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SampleValue
  ): zio.aws.lexmodelsv2.model.SampleValue.ReadOnly = new Wrapper(impl)
}
