package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  LocaleName,
  Timestamp,
  ConfidenceThreshold,
  DraftBotVersion,
  Description,
  Id
}
import scala.jdk.CollectionConverters._
final case class CreateBotLocaleResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[DraftBotVersion] = Optional.Absent,
    localeName: Optional[LocaleName] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    nluIntentConfidenceThreshold: Optional[ConfidenceThreshold] =
      Optional.Absent,
    voiceSettings: Optional[zio.aws.lexmodelsv2.model.VoiceSettings] =
      Optional.Absent,
    botLocaleStatus: Optional[zio.aws.lexmodelsv2.model.BotLocaleStatus] =
      Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse = {
    import CreateBotLocaleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeName.map(value => LocaleName.unwrap(value): java.lang.String)
      )(_.localeName)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        nluIntentConfidenceThreshold.map(value =>
          ConfidenceThreshold.unwrap(value): java.lang.Double
        )
      )(_.nluIntentConfidenceThreshold)
      .optionallyWith(voiceSettings.map(value => value.buildAwsValue()))(
        _.voiceSettings
      )
      .optionallyWith(botLocaleStatus.map(value => value.unwrap))(
        _.botLocaleStatus
      )
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateBotLocaleResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateBotLocaleResponse.wrap(buildAwsValue())
}
object CreateBotLocaleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateBotLocaleResponse =
      zio.aws.lexmodelsv2.model.CreateBotLocaleResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeName.map(value => value),
        localeId.map(value => value),
        description.map(value => value),
        nluIntentConfidenceThreshold.map(value => value),
        voiceSettings.map(value => value.asEditable),
        botLocaleStatus.map(value => value),
        creationDateTime.map(value => value)
      )
    def botId: Optional[Id]
    def botVersion: Optional[DraftBotVersion]
    def localeName: Optional[LocaleName]
    def localeId: Optional[LocaleId]
    def description: Optional[Description]
    def nluIntentConfidenceThreshold: Optional[ConfidenceThreshold]
    def voiceSettings
        : Optional[zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly]
    def botLocaleStatus: Optional[zio.aws.lexmodelsv2.model.BotLocaleStatus]
    def creationDateTime: Optional[Timestamp]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleName: ZIO[Any, AwsError, LocaleName] =
      AwsError.unwrapOptionField("localeName", localeName)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNluIntentConfidenceThreshold
        : ZIO[Any, AwsError, ConfidenceThreshold] = AwsError.unwrapOptionField(
      "nluIntentConfidenceThreshold",
      nluIntentConfidenceThreshold
    )
    def getVoiceSettings
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly] =
      AwsError.unwrapOptionField("voiceSettings", voiceSettings)
    def getBotLocaleStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotLocaleStatus] =
      AwsError.unwrapOptionField("botLocaleStatus", botLocaleStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse
  ) extends zio.aws.lexmodelsv2.model.CreateBotLocaleResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[DraftBotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val localeName: Optional[LocaleName] = zio.aws.core.internal
      .optionalFromNullable(impl.localeName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleName(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val nluIntentConfidenceThreshold: Optional[ConfidenceThreshold] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nluIntentConfidenceThreshold())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.ConfidenceThreshold(value)
        )
    override val voiceSettings
        : Optional[zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceSettings())
        .map(value => zio.aws.lexmodelsv2.model.VoiceSettings.wrap(value))
    override val botLocaleStatus
        : Optional[zio.aws.lexmodelsv2.model.BotLocaleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botLocaleStatus())
        .map(value => zio.aws.lexmodelsv2.model.BotLocaleStatus.wrap(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse
  ): zio.aws.lexmodelsv2.model.CreateBotLocaleResponse.ReadOnly = new Wrapper(
    impl
  )
}
