package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  BotAliasId,
  Timestamp,
  Description,
  BotVersion,
  Name
}
import scala.jdk.CollectionConverters._
final case class BotAliasSummary(
    botAliasId: Optional[BotAliasId] = Optional.Absent,
    botAliasName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    botAliasStatus: Optional[zio.aws.lexmodelsv2.model.BotAliasStatus] =
      Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotAliasSummary = {
    import BotAliasSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotAliasSummary
      .builder()
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(
        botAliasName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botAliasName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(botAliasStatus.map(value => value.unwrap))(
        _.botAliasStatus
      )
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotAliasSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.BotAliasSummary.wrap(buildAwsValue())
}
object BotAliasSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotAliasSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotAliasSummary =
      zio.aws.lexmodelsv2.model.BotAliasSummary(
        botAliasId.map(value => value),
        botAliasName.map(value => value),
        description.map(value => value),
        botVersion.map(value => value),
        botAliasStatus.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def botAliasId: Optional[BotAliasId]
    def botAliasName: Optional[Name]
    def description: Optional[Description]
    def botVersion: Optional[BotVersion]
    def botAliasStatus: Optional[zio.aws.lexmodelsv2.model.BotAliasStatus]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotAliasName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botAliasName", botAliasName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getBotAliasStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotAliasStatus] =
      AwsError.unwrapOptionField("botAliasStatus", botAliasStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotAliasSummary
  ) extends zio.aws.lexmodelsv2.model.BotAliasSummary.ReadOnly {
    override val botAliasId: Optional[BotAliasId] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botAliasName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val botAliasStatus
        : Optional[zio.aws.lexmodelsv2.model.BotAliasStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botAliasStatus())
        .map(value => zio.aws.lexmodelsv2.model.BotAliasStatus.wrap(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotAliasSummary
  ): zio.aws.lexmodelsv2.model.BotAliasSummary.ReadOnly = new Wrapper(impl)
}
