package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  Timestamp,
  NumericalBotVersion,
  Description,
  Id
}
import scala.jdk.CollectionConverters._
final case class CreateBotVersionResponse(
    botId: Optional[Id] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    botVersion: Optional[NumericalBotVersion] = Optional.Absent,
    botVersionLocaleSpecification: Optional[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotVersionLocaleDetails]
    ] = Optional.Absent,
    botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse = {
    import CreateBotVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        botVersion.map(value =>
          NumericalBotVersion.unwrap(value): java.lang.String
        )
      )(_.botVersion)
      .optionallyWith(
        botVersionLocaleSpecification.map(value =>
          value
            .map({ case (key, value) =>
              (LocaleId.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.botVersionLocaleSpecification)
      .optionallyWith(botStatus.map(value => value.unwrap))(_.botStatus)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateBotVersionResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateBotVersionResponse.wrap(buildAwsValue())
}
object CreateBotVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateBotVersionResponse =
      zio.aws.lexmodelsv2.model.CreateBotVersionResponse(
        botId.map(value => value),
        description.map(value => value),
        botVersion.map(value => value),
        botVersionLocaleSpecification.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        botStatus.map(value => value),
        creationDateTime.map(value => value)
      )
    def botId: Optional[Id]
    def description: Optional[Description]
    def botVersion: Optional[NumericalBotVersion]
    def botVersionLocaleSpecification: Optional[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotVersionLocaleDetails.ReadOnly]
    ]
    def botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus]
    def creationDateTime: Optional[Timestamp]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotVersion: ZIO[Any, AwsError, NumericalBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getBotVersionLocaleSpecification: ZIO[Any, AwsError, Map[
      LocaleId,
      zio.aws.lexmodelsv2.model.BotVersionLocaleDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "botVersionLocaleSpecification",
      botVersionLocaleSpecification
    )
    def getBotStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotStatus] =
      AwsError.unwrapOptionField("botStatus", botStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse
  ) extends zio.aws.lexmodelsv2.model.CreateBotVersionResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botVersion: Optional[NumericalBotVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botVersion())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.NumericalBotVersion(value)
        )
    override val botVersionLocaleSpecification: Optional[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotVersionLocaleDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersionLocaleSpecification())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.LocaleId(
              key
            ) -> zio.aws.lexmodelsv2.model.BotVersionLocaleDetails.wrap(value)
          })
          .toMap
      )
    override val botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botStatus())
        .map(value => zio.aws.lexmodelsv2.model.BotStatus.wrap(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse
  ): zio.aws.lexmodelsv2.model.CreateBotVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
