package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  Timestamp,
  SlotTypeSignature,
  DraftBotVersion,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters._
final case class UpdateSlotTypeResponse(
    slotTypeId: Optional[Id] = Optional.Absent,
    slotTypeName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    slotTypeValues: Optional[
      Iterable[zio.aws.lexmodelsv2.model.SlotTypeValue]
    ] = Optional.Absent,
    valueSelectionSetting: Optional[
      zio.aws.lexmodelsv2.model.SlotValueSelectionSetting
    ] = Optional.Absent,
    parentSlotTypeSignature: Optional[SlotTypeSignature] = Optional.Absent,
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[DraftBotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent,
    externalSourceSetting: Optional[
      zio.aws.lexmodelsv2.model.ExternalSourceSetting
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse = {
    import UpdateSlotTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse
      .builder()
      .optionallyWith(
        slotTypeId.map(value => Id.unwrap(value): java.lang.String)
      )(_.slotTypeId)
      .optionallyWith(
        slotTypeName.map(value => Name.unwrap(value): java.lang.String)
      )(_.slotTypeName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        slotTypeValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.slotTypeValues)
      .optionallyWith(
        valueSelectionSetting.map(value => value.buildAwsValue())
      )(_.valueSelectionSetting)
      .optionallyWith(
        parentSlotTypeSignature.map(value =>
          SlotTypeSignature.unwrap(value): java.lang.String
        )
      )(_.parentSlotTypeSignature)
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        externalSourceSetting.map(value => value.buildAwsValue())
      )(_.externalSourceSetting)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateSlotTypeResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateSlotTypeResponse.wrap(buildAwsValue())
}
object UpdateSlotTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateSlotTypeResponse =
      zio.aws.lexmodelsv2.model.UpdateSlotTypeResponse(
        slotTypeId.map(value => value),
        slotTypeName.map(value => value),
        description.map(value => value),
        slotTypeValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        valueSelectionSetting.map(value => value.asEditable),
        parentSlotTypeSignature.map(value => value),
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        externalSourceSetting.map(value => value.asEditable)
      )
    def slotTypeId: Optional[Id]
    def slotTypeName: Optional[Name]
    def description: Optional[Description]
    def slotTypeValues
        : Optional[List[zio.aws.lexmodelsv2.model.SlotTypeValue.ReadOnly]]
    def valueSelectionSetting
        : Optional[zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.ReadOnly]
    def parentSlotTypeSignature: Optional[SlotTypeSignature]
    def botId: Optional[Id]
    def botVersion: Optional[DraftBotVersion]
    def localeId: Optional[LocaleId]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def externalSourceSetting
        : Optional[zio.aws.lexmodelsv2.model.ExternalSourceSetting.ReadOnly]
    def getSlotTypeId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("slotTypeId", slotTypeId)
    def getSlotTypeName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("slotTypeName", slotTypeName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSlotTypeValues: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SlotTypeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("slotTypeValues", slotTypeValues)
    def getValueSelectionSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.ReadOnly
    ] =
      AwsError.unwrapOptionField("valueSelectionSetting", valueSelectionSetting)
    def getParentSlotTypeSignature: ZIO[Any, AwsError, SlotTypeSignature] =
      AwsError.unwrapOptionField(
        "parentSlotTypeSignature",
        parentSlotTypeSignature
      )
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getExternalSourceSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ExternalSourceSetting.ReadOnly
    ] =
      AwsError.unwrapOptionField("externalSourceSetting", externalSourceSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse
  ) extends zio.aws.lexmodelsv2.model.UpdateSlotTypeResponse.ReadOnly {
    override val slotTypeId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.slotTypeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val slotTypeName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.slotTypeName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val slotTypeValues
        : Optional[List[zio.aws.lexmodelsv2.model.SlotTypeValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slotTypeValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.SlotTypeValue.wrap(item)
          }.toList
        )
    override val valueSelectionSetting: Optional[
      zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.valueSelectionSetting())
      .map(value =>
        zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.wrap(value)
      )
    override val parentSlotTypeSignature: Optional[SlotTypeSignature] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentSlotTypeSignature())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.SlotTypeSignature(value)
        )
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[DraftBotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val externalSourceSetting
        : Optional[zio.aws.lexmodelsv2.model.ExternalSourceSetting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalSourceSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.ExternalSourceSetting.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse
  ): zio.aws.lexmodelsv2.model.UpdateSlotTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
