package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  SlotTypeSignature,
  DraftBotVersion,
  Description,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSlotTypeRequest(
    slotTypeId: Id,
    slotTypeName: Name,
    description: Optional[Description] = Optional.Absent,
    slotTypeValues: Optional[
      Iterable[zio.aws.lexmodelsv2.model.SlotTypeValue]
    ] = Optional.Absent,
    valueSelectionSetting: Optional[
      zio.aws.lexmodelsv2.model.SlotValueSelectionSetting
    ] = Optional.Absent,
    parentSlotTypeSignature: Optional[SlotTypeSignature] = Optional.Absent,
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId,
    externalSourceSetting: Optional[
      zio.aws.lexmodelsv2.model.ExternalSourceSetting
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest = {
    import UpdateSlotTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest
      .builder()
      .slotTypeId(Id.unwrap(slotTypeId): java.lang.String)
      .slotTypeName(Name.unwrap(slotTypeName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        slotTypeValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.slotTypeValues)
      .optionallyWith(
        valueSelectionSetting.map(value => value.buildAwsValue())
      )(_.valueSelectionSetting)
      .optionallyWith(
        parentSlotTypeSignature.map(value =>
          SlotTypeSignature.unwrap(value): java.lang.String
        )
      )(_.parentSlotTypeSignature)
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .optionallyWith(
        externalSourceSetting.map(value => value.buildAwsValue())
      )(_.externalSourceSetting)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateSlotTypeRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateSlotTypeRequest.wrap(buildAwsValue())
}
object UpdateSlotTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateSlotTypeRequest =
      zio.aws.lexmodelsv2.model.UpdateSlotTypeRequest(
        slotTypeId,
        slotTypeName,
        description.map(value => value),
        slotTypeValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        valueSelectionSetting.map(value => value.asEditable),
        parentSlotTypeSignature.map(value => value),
        botId,
        botVersion,
        localeId,
        externalSourceSetting.map(value => value.asEditable)
      )
    def slotTypeId: Id
    def slotTypeName: Name
    def description: Optional[Description]
    def slotTypeValues
        : Optional[List[zio.aws.lexmodelsv2.model.SlotTypeValue.ReadOnly]]
    def valueSelectionSetting
        : Optional[zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.ReadOnly]
    def parentSlotTypeSignature: Optional[SlotTypeSignature]
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def externalSourceSetting
        : Optional[zio.aws.lexmodelsv2.model.ExternalSourceSetting.ReadOnly]
    def getSlotTypeId: ZIO[Any, Nothing, Id] = ZIO.succeed(slotTypeId)
    def getSlotTypeName: ZIO[Any, Nothing, Name] = ZIO.succeed(slotTypeName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSlotTypeValues: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SlotTypeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("slotTypeValues", slotTypeValues)
    def getValueSelectionSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.ReadOnly
    ] =
      AwsError.unwrapOptionField("valueSelectionSetting", valueSelectionSetting)
    def getParentSlotTypeSignature: ZIO[Any, AwsError, SlotTypeSignature] =
      AwsError.unwrapOptionField(
        "parentSlotTypeSignature",
        parentSlotTypeSignature
      )
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getExternalSourceSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ExternalSourceSetting.ReadOnly
    ] =
      AwsError.unwrapOptionField("externalSourceSetting", externalSourceSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest
  ) extends zio.aws.lexmodelsv2.model.UpdateSlotTypeRequest.ReadOnly {
    override val slotTypeId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.slotTypeId())
    override val slotTypeName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.slotTypeName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val slotTypeValues
        : Optional[List[zio.aws.lexmodelsv2.model.SlotTypeValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slotTypeValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.SlotTypeValue.wrap(item)
          }.toList
        )
    override val valueSelectionSetting: Optional[
      zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.valueSelectionSetting())
      .map(value =>
        zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.wrap(value)
      )
    override val parentSlotTypeSignature: Optional[SlotTypeSignature] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentSlotTypeSignature())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.SlotTypeSignature(value)
        )
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val externalSourceSetting
        : Optional[zio.aws.lexmodelsv2.model.ExternalSourceSetting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalSourceSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.ExternalSourceSetting.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest
  ): zio.aws.lexmodelsv2.model.UpdateSlotTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
