package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  NextToken,
  BotAliasId,
  MaxResults,
  BotVersion,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAggregatedUtterancesRequest(
    botId: Id,
    botAliasId: Optional[BotAliasId] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    localeId: LocaleId,
    aggregationDuration: zio.aws.lexmodelsv2.model.UtteranceAggregationDuration,
    sortBy: Optional[zio.aws.lexmodelsv2.model.AggregatedUtterancesSortBy] =
      Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter]
    ] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest = {
    import ListAggregatedUtterancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .aggregationDuration(aggregationDuration.buildAwsValue())
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListAggregatedUtterancesRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListAggregatedUtterancesRequest
      .wrap(buildAwsValue())
}
object ListAggregatedUtterancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListAggregatedUtterancesRequest =
      zio.aws.lexmodelsv2.model.ListAggregatedUtterancesRequest(
        botId,
        botAliasId.map(value => value),
        botVersion.map(value => value),
        localeId,
        aggregationDuration.asEditable,
        sortBy.map(value => value.asEditable),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def botId: Id
    def botAliasId: Optional[BotAliasId]
    def botVersion: Optional[BotVersion]
    def localeId: LocaleId
    def aggregationDuration
        : zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.ReadOnly
    def sortBy: Optional[
      zio.aws.lexmodelsv2.model.AggregatedUtterancesSortBy.ReadOnly
    ]
    def filters: Optional[
      List[zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter.ReadOnly]
    ]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getAggregationDuration: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.ReadOnly
    ] = ZIO.succeed(aggregationDuration)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AggregatedUtterancesSortBy.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest
  ) extends zio.aws.lexmodelsv2.model.ListAggregatedUtterancesRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botAliasId: Optional[BotAliasId] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val aggregationDuration
        : zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.ReadOnly =
      zio.aws.lexmodelsv2.model.UtteranceAggregationDuration
        .wrap(impl.aggregationDuration())
    override val sortBy: Optional[
      zio.aws.lexmodelsv2.model.AggregatedUtterancesSortBy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sortBy())
      .map(value =>
        zio.aws.lexmodelsv2.model.AggregatedUtterancesSortBy.wrap(value)
      )
    override val filters: Optional[
      List[zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest
  ): zio.aws.lexmodelsv2.model.ListAggregatedUtterancesRequest.ReadOnly =
    new Wrapper(impl)
}
