package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait SlotValueResolutionStrategy {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.SlotValueResolutionStrategy
}
object SlotValueResolutionStrategy {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.SlotValueResolutionStrategy
  ): zio.aws.lexmodelsv2.model.SlotValueResolutionStrategy = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotValueResolutionStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotValueResolutionStrategy.ORIGINAL_VALUE =>
      val r = OriginalValue
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotValueResolutionStrategy.TOP_RESOLUTION =>
      val r = TopResolution
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.SlotValueResolutionStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotValueResolutionStrategy =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotValueResolutionStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object OriginalValue
      extends zio.aws.lexmodelsv2.model.SlotValueResolutionStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotValueResolutionStrategy =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotValueResolutionStrategy.ORIGINAL_VALUE
  }
  case object TopResolution
      extends zio.aws.lexmodelsv2.model.SlotValueResolutionStrategy {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotValueResolutionStrategy =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotValueResolutionStrategy.TOP_RESOLUTION
  }
}
