package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.FilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExportFilter(
    name: zio.aws.lexmodelsv2.model.ExportFilterName,
    values: Iterable[FilterValue],
    operator: zio.aws.lexmodelsv2.model.ExportFilterOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ExportFilter = {
    import ExportFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ExportFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ExportFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.ExportFilter.wrap(buildAwsValue())
}
object ExportFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ExportFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ExportFilter =
      zio.aws.lexmodelsv2.model.ExportFilter(name, values, operator)
    def name: zio.aws.lexmodelsv2.model.ExportFilterName
    def values: List[FilterValue]
    def operator: zio.aws.lexmodelsv2.model.ExportFilterOperator
    def getName: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.ExportFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.ExportFilterOperator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ExportFilter
  ) extends zio.aws.lexmodelsv2.model.ExportFilter.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.ExportFilterName =
      zio.aws.lexmodelsv2.model.ExportFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.primitives.FilterValue(item)
      }
      .toList
    override val operator: zio.aws.lexmodelsv2.model.ExportFilterOperator =
      zio.aws.lexmodelsv2.model.ExportFilterOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ExportFilter
  ): zio.aws.lexmodelsv2.model.ExportFilter.ReadOnly = new Wrapper(impl)
}
