package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{ImportExportFilePassword, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartImportRequest(
    importId: Id,
    resourceSpecification: zio.aws.lexmodelsv2.model.ImportResourceSpecification,
    mergeStrategy: zio.aws.lexmodelsv2.model.MergeStrategy,
    filePassword: Optional[ImportExportFilePassword] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.StartImportRequest = {
    import StartImportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.StartImportRequest
      .builder()
      .importId(Id.unwrap(importId): java.lang.String)
      .resourceSpecification(resourceSpecification.buildAwsValue())
      .mergeStrategy(mergeStrategy.unwrap)
      .optionallyWith(
        filePassword.map(value =>
          ImportExportFilePassword.unwrap(value): java.lang.String
        )
      )(_.filePassword)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.StartImportRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.StartImportRequest.wrap(buildAwsValue())
}
object StartImportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.StartImportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.StartImportRequest =
      zio.aws.lexmodelsv2.model.StartImportRequest(
        importId,
        resourceSpecification.asEditable,
        mergeStrategy,
        filePassword.map(value => value)
      )
    def importId: Id
    def resourceSpecification
        : zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly
    def mergeStrategy: zio.aws.lexmodelsv2.model.MergeStrategy
    def filePassword: Optional[ImportExportFilePassword]
    def getImportId: ZIO[Any, Nothing, Id] = ZIO.succeed(importId)
    def getResourceSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly
    ] = ZIO.succeed(resourceSpecification)
    def getMergeStrategy
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.MergeStrategy] =
      ZIO.succeed(mergeStrategy)
    def getFilePassword: ZIO[Any, AwsError, ImportExportFilePassword] =
      AwsError.unwrapOptionField("filePassword", filePassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartImportRequest
  ) extends zio.aws.lexmodelsv2.model.StartImportRequest.ReadOnly {
    override val importId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.importId())
    override val resourceSpecification
        : zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.ImportResourceSpecification
        .wrap(impl.resourceSpecification())
    override val mergeStrategy: zio.aws.lexmodelsv2.model.MergeStrategy =
      zio.aws.lexmodelsv2.model.MergeStrategy.wrap(impl.mergeStrategy())
    override val filePassword: Optional[ImportExportFilePassword] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filePassword())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.ImportExportFilePassword(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartImportRequest
  ): zio.aws.lexmodelsv2.model.StartImportRequest.ReadOnly = new Wrapper(impl)
}
