package zio.aws.lexmodelsv2
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  ConditionKey,
  RecommendedAction,
  FailureReason,
  TagValue,
  Operation,
  ConditionOperator,
  ConditionValue,
  ObjectPrefix,
  FilterValue,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.lexmodelsv2.model.primitives.Policy.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.lexmodelsv2.model.primitives.AmazonResourceName.Type
    object AttachmentTitle extends Subtype[String]
    type AttachmentTitle =
      zio.aws.lexmodelsv2.model.primitives.AttachmentTitle.Type
    object AttachmentUrl extends Subtype[String]
    type AttachmentUrl = zio.aws.lexmodelsv2.model.primitives.AttachmentUrl.Type
    object BotAliasId extends Subtype[String]
    type BotAliasId = zio.aws.lexmodelsv2.model.primitives.BotAliasId.Type
    object BotLocaleHistoryEventDescription extends Subtype[String]
    type BotLocaleHistoryEventDescription =
      zio.aws.lexmodelsv2.model.primitives.BotLocaleHistoryEventDescription.Type
    object BotVersion extends Subtype[String]
    type BotVersion = zio.aws.lexmodelsv2.model.primitives.BotVersion.Type
    type BoxedBoolean = Boolean
    object BuiltInOrCustomSlotTypeId extends Subtype[String]
    type BuiltInOrCustomSlotTypeId =
      zio.aws.lexmodelsv2.model.primitives.BuiltInOrCustomSlotTypeId.Type
    object BuiltInsMaxResults extends Subtype[Int]
    type BuiltInsMaxResults =
      zio.aws.lexmodelsv2.model.primitives.BuiltInsMaxResults.Type
    object ButtonText extends Subtype[String]
    type ButtonText = zio.aws.lexmodelsv2.model.primitives.ButtonText.Type
    object ButtonValue extends Subtype[String]
    type ButtonValue = zio.aws.lexmodelsv2.model.primitives.ButtonValue.Type
    object ChildDirected extends Subtype[Boolean]
    type ChildDirected = zio.aws.lexmodelsv2.model.primitives.ChildDirected.Type
    object CloudWatchLogGroupArn extends Subtype[String]
    type CloudWatchLogGroupArn =
      zio.aws.lexmodelsv2.model.primitives.CloudWatchLogGroupArn.Type
    object CodeHookInterfaceVersion extends Subtype[String]
    type CodeHookInterfaceVersion =
      zio.aws.lexmodelsv2.model.primitives.CodeHookInterfaceVersion.Type
    object ConditionKey extends Subtype[String]
    type ConditionKey = zio.aws.lexmodelsv2.model.primitives.ConditionKey.Type
    object ConditionOperator extends Subtype[String]
    type ConditionOperator =
      zio.aws.lexmodelsv2.model.primitives.ConditionOperator.Type
    object ConditionValue extends Subtype[String]
    type ConditionValue =
      zio.aws.lexmodelsv2.model.primitives.ConditionValue.Type
    object ConfidenceThreshold extends Subtype[Double]
    type ConfidenceThreshold =
      zio.aws.lexmodelsv2.model.primitives.ConfidenceThreshold.Type
    object ContextTimeToLiveInSeconds extends Subtype[Int]
    type ContextTimeToLiveInSeconds =
      zio.aws.lexmodelsv2.model.primitives.ContextTimeToLiveInSeconds.Type
    object ContextTurnsToLive extends Subtype[Int]
    type ContextTurnsToLive =
      zio.aws.lexmodelsv2.model.primitives.ContextTurnsToLive.Type
    object Count extends Subtype[Int]
    type Count = zio.aws.lexmodelsv2.model.primitives.Count.Type
    object CustomPayloadValue extends Subtype[String]
    type CustomPayloadValue =
      zio.aws.lexmodelsv2.model.primitives.CustomPayloadValue.Type
    object Description extends Subtype[String]
    type Description = zio.aws.lexmodelsv2.model.primitives.Description.Type
    object DraftBotVersion extends Subtype[String]
    type DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion.Type
    object FailureReason extends Subtype[String]
    type FailureReason = zio.aws.lexmodelsv2.model.primitives.FailureReason.Type
    object FilePassword extends Subtype[String]
    type FilePassword = zio.aws.lexmodelsv2.model.primitives.FilePassword.Type
    object FilterValue extends Subtype[String]
    type FilterValue = zio.aws.lexmodelsv2.model.primitives.FilterValue.Type
    object FulfillmentStartResponseDelay extends Subtype[Int]
    type FulfillmentStartResponseDelay =
      zio.aws.lexmodelsv2.model.primitives.FulfillmentStartResponseDelay.Type
    object FulfillmentTimeout extends Subtype[Int]
    type FulfillmentTimeout =
      zio.aws.lexmodelsv2.model.primitives.FulfillmentTimeout.Type
    object FulfillmentUpdateResponseFrequency extends Subtype[Int]
    type FulfillmentUpdateResponseFrequency =
      zio.aws.lexmodelsv2.model.primitives.FulfillmentUpdateResponseFrequency.Type
    object HitCount extends Subtype[Int]
    type HitCount = zio.aws.lexmodelsv2.model.primitives.HitCount.Type
    object Id extends Subtype[String]
    type Id = zio.aws.lexmodelsv2.model.primitives.Id.Type
    object ImportExportFilePassword extends Subtype[String]
    type ImportExportFilePassword =
      zio.aws.lexmodelsv2.model.primitives.ImportExportFilePassword.Type
    object ImportedResourceId extends Subtype[String]
    type ImportedResourceId =
      zio.aws.lexmodelsv2.model.primitives.ImportedResourceId.Type
    object IntentSignature extends Subtype[String]
    type IntentSignature =
      zio.aws.lexmodelsv2.model.primitives.IntentSignature.Type
    object KendraIndexArn extends Subtype[String]
    type KendraIndexArn =
      zio.aws.lexmodelsv2.model.primitives.KendraIndexArn.Type
    object KmsKeyArn extends Subtype[String]
    type KmsKeyArn = zio.aws.lexmodelsv2.model.primitives.KmsKeyArn.Type
    object LambdaARN extends Subtype[String]
    type LambdaARN = zio.aws.lexmodelsv2.model.primitives.LambdaARN.Type
    object LocaleId extends Subtype[String]
    type LocaleId = zio.aws.lexmodelsv2.model.primitives.LocaleId.Type
    object LocaleName extends Subtype[String]
    type LocaleName = zio.aws.lexmodelsv2.model.primitives.LocaleName.Type
    object LogPrefix extends Subtype[String]
    type LogPrefix = zio.aws.lexmodelsv2.model.primitives.LogPrefix.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.lexmodelsv2.model.primitives.MaxResults.Type
    object MissedCount extends Subtype[Int]
    type MissedCount = zio.aws.lexmodelsv2.model.primitives.MissedCount.Type
    object Name extends Subtype[String]
    type Name = zio.aws.lexmodelsv2.model.primitives.Name.Type
    object NextIndex extends Subtype[Int]
    type NextIndex = zio.aws.lexmodelsv2.model.primitives.NextIndex.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.lexmodelsv2.model.primitives.NextToken.Type
    object NumericalBotVersion extends Subtype[String]
    type NumericalBotVersion =
      zio.aws.lexmodelsv2.model.primitives.NumericalBotVersion.Type
    object ObjectPrefix extends Subtype[String]
    type ObjectPrefix = zio.aws.lexmodelsv2.model.primitives.ObjectPrefix.Type
    object Operation extends Subtype[String]
    type Operation = zio.aws.lexmodelsv2.model.primitives.Operation.Type
    object PlainTextMessageValue extends Subtype[String]
    type PlainTextMessageValue =
      zio.aws.lexmodelsv2.model.primitives.PlainTextMessageValue.Type
    object Policy extends Subtype[String]
    type Policy = zio.aws.lexmodelsv2.model.primitives.Policy.Type
    object PresignedS3Url extends Subtype[String]
    type PresignedS3Url =
      zio.aws.lexmodelsv2.model.primitives.PresignedS3Url.Type
    object PrincipalArn extends Subtype[String]
    type PrincipalArn = zio.aws.lexmodelsv2.model.primitives.PrincipalArn.Type
    object PriorityValue extends Subtype[Int]
    type PriorityValue = zio.aws.lexmodelsv2.model.primitives.PriorityValue.Type
    object PromptMaxRetries extends Subtype[Int]
    type PromptMaxRetries =
      zio.aws.lexmodelsv2.model.primitives.PromptMaxRetries.Type
    object QueryFilterString extends Subtype[String]
    type QueryFilterString =
      zio.aws.lexmodelsv2.model.primitives.QueryFilterString.Type
    object RecommendedAction extends Subtype[String]
    type RecommendedAction =
      zio.aws.lexmodelsv2.model.primitives.RecommendedAction.Type
    object RegexPattern extends Subtype[String]
    type RegexPattern = zio.aws.lexmodelsv2.model.primitives.RegexPattern.Type
    object ResourceCount extends Subtype[Int]
    type ResourceCount = zio.aws.lexmodelsv2.model.primitives.ResourceCount.Type
    object RevisionId extends Subtype[String]
    type RevisionId = zio.aws.lexmodelsv2.model.primitives.RevisionId.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.lexmodelsv2.model.primitives.RoleArn.Type
    object S3BucketArn extends Subtype[String]
    type S3BucketArn = zio.aws.lexmodelsv2.model.primitives.S3BucketArn.Type
    object S3BucketName extends Subtype[String]
    type S3BucketName = zio.aws.lexmodelsv2.model.primitives.S3BucketName.Type
    object S3ObjectPath extends Subtype[String]
    type S3ObjectPath = zio.aws.lexmodelsv2.model.primitives.S3ObjectPath.Type
    object SSMLMessageValue extends Subtype[String]
    type SSMLMessageValue =
      zio.aws.lexmodelsv2.model.primitives.SSMLMessageValue.Type
    object SampleUtterancesCount extends Subtype[Int]
    type SampleUtterancesCount =
      zio.aws.lexmodelsv2.model.primitives.SampleUtterancesCount.Type
    object ServicePrincipal extends Subtype[String]
    type ServicePrincipal =
      zio.aws.lexmodelsv2.model.primitives.ServicePrincipal.Type
    object SessionId extends Subtype[String]
    type SessionId = zio.aws.lexmodelsv2.model.primitives.SessionId.Type
    object SessionTTL extends Subtype[Int]
    type SessionTTL = zio.aws.lexmodelsv2.model.primitives.SessionTTL.Type
    object SkipResourceInUseCheck extends Subtype[Boolean]
    type SkipResourceInUseCheck =
      zio.aws.lexmodelsv2.model.primitives.SkipResourceInUseCheck.Type
    object SlotDefaultValueString extends Subtype[String]
    type SlotDefaultValueString =
      zio.aws.lexmodelsv2.model.primitives.SlotDefaultValueString.Type
    object SlotTypeSignature extends Subtype[String]
    type SlotTypeSignature =
      zio.aws.lexmodelsv2.model.primitives.SlotTypeSignature.Type
    object StillWaitingResponseFrequency extends Subtype[Int]
    type StillWaitingResponseFrequency =
      zio.aws.lexmodelsv2.model.primitives.StillWaitingResponseFrequency.Type
    object StillWaitingResponseTimeout extends Subtype[Int]
    type StillWaitingResponseTimeout =
      zio.aws.lexmodelsv2.model.primitives.StillWaitingResponseTimeout.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.lexmodelsv2.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.lexmodelsv2.model.primitives.TagValue.Type
    object TimeValue extends Subtype[Int]
    type TimeValue = zio.aws.lexmodelsv2.model.primitives.TimeValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.lexmodelsv2.model.primitives.Timestamp.Type
    object Transcript extends Subtype[String]
    type Transcript = zio.aws.lexmodelsv2.model.primitives.Transcript.Type
    object Utterance extends Subtype[String]
    type Utterance = zio.aws.lexmodelsv2.model.primitives.Utterance.Type
    object Value extends Subtype[String]
    type Value = zio.aws.lexmodelsv2.model.primitives.Value.Type
    object VoiceId extends Subtype[String]
    type VoiceId = zio.aws.lexmodelsv2.model.primitives.VoiceId.Type
  }
  type AggregatedUtterancesFilters =
    List[zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter]
  type AggregatedUtterancesSummaryList =
    List[zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary]
  type AssociatedTranscriptFilters =
    List[zio.aws.lexmodelsv2.model.AssociatedTranscriptFilter]
  type AssociatedTranscriptList =
    List[zio.aws.lexmodelsv2.model.AssociatedTranscript]
  type AudioLogSettingsList = List[zio.aws.lexmodelsv2.model.AudioLogSetting]
  type BotAliasHistoryEventsList =
    List[zio.aws.lexmodelsv2.model.BotAliasHistoryEvent]
  type BotAliasLocaleSettingsMap =
    Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings]
  type BotAliasSummaryList = List[zio.aws.lexmodelsv2.model.BotAliasSummary]
  type BotFilters = List[zio.aws.lexmodelsv2.model.BotFilter]
  type BotLocaleFilters = List[zio.aws.lexmodelsv2.model.BotLocaleFilter]
  type BotLocaleHistoryEventsList =
    List[zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent]
  type BotLocaleSummaryList = List[zio.aws.lexmodelsv2.model.BotLocaleSummary]
  type BotRecommendationSummaryList =
    List[zio.aws.lexmodelsv2.model.BotRecommendationSummary]
  type BotSummaryList = List[zio.aws.lexmodelsv2.model.BotSummary]
  type BotVersionLocaleSpecification =
    Map[LocaleId, zio.aws.lexmodelsv2.model.BotVersionLocaleDetails]
  type BotVersionSummaryList = List[zio.aws.lexmodelsv2.model.BotVersionSummary]
  type BuiltInIntentSummaryList =
    List[zio.aws.lexmodelsv2.model.BuiltInIntentSummary]
  type BuiltInSlotTypeSummaryList =
    List[zio.aws.lexmodelsv2.model.BuiltInSlotTypeSummary]
  type ButtonsList = List[zio.aws.lexmodelsv2.model.Button]
  type ConditionKeyValueMap = Map[ConditionKey, ConditionValue]
  type ConditionMap = Map[ConditionOperator, Map[ConditionKey, ConditionValue]]
  type ExportFilters = List[zio.aws.lexmodelsv2.model.ExportFilter]
  type ExportSummaryList = List[zio.aws.lexmodelsv2.model.ExportSummary]
  type FailureReasons = List[FailureReason]
  type FilterValues = List[FilterValue]
  type ImportFilters = List[zio.aws.lexmodelsv2.model.ImportFilter]
  type ImportSummaryList = List[zio.aws.lexmodelsv2.model.ImportSummary]
  type InputContextsList = List[zio.aws.lexmodelsv2.model.InputContext]
  type IntentFilters = List[zio.aws.lexmodelsv2.model.IntentFilter]
  type IntentSummaryList = List[zio.aws.lexmodelsv2.model.IntentSummary]
  type MessageGroupsList = List[zio.aws.lexmodelsv2.model.MessageGroup]
  type MessageVariationsList = List[zio.aws.lexmodelsv2.model.Message]
  type ObjectPrefixes = List[ObjectPrefix]
  type OperationList = List[Operation]
  type OutputContextsList = List[zio.aws.lexmodelsv2.model.OutputContext]
  type PrincipalList = List[zio.aws.lexmodelsv2.model.Principal]
  type RecommendedActions = List[RecommendedAction]
  type RecommendedIntentSummaryList =
    List[zio.aws.lexmodelsv2.model.RecommendedIntentSummary]
  type SampleUtterancesList = List[zio.aws.lexmodelsv2.model.SampleUtterance]
  type SlotDefaultValueList = List[zio.aws.lexmodelsv2.model.SlotDefaultValue]
  type SlotFilters = List[zio.aws.lexmodelsv2.model.SlotFilter]
  type SlotPrioritiesList = List[zio.aws.lexmodelsv2.model.SlotPriority]
  type SlotSummaryList = List[zio.aws.lexmodelsv2.model.SlotSummary]
  type SlotTypeFilters = List[zio.aws.lexmodelsv2.model.SlotTypeFilter]
  type SlotTypeSummaryList = List[zio.aws.lexmodelsv2.model.SlotTypeSummary]
  type SlotTypeValues = List[zio.aws.lexmodelsv2.model.SlotTypeValue]
  type SynonymList = List[zio.aws.lexmodelsv2.model.SampleValue]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TextLogSettingsList = List[zio.aws.lexmodelsv2.model.TextLogSetting]
}
