package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.Count
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SlotTypeStatistics(
    discoveredSlotTypeCount: Optional[Count] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeStatistics = {
    import SlotTypeStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeStatistics
      .builder()
      .optionallyWith(
        discoveredSlotTypeCount.map(value => Count.unwrap(value): Integer)
      )(_.discoveredSlotTypeCount)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotTypeStatistics.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotTypeStatistics.wrap(buildAwsValue())
}
object SlotTypeStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotTypeStatistics =
      zio.aws.lexmodelsv2.model
        .SlotTypeStatistics(discoveredSlotTypeCount.map(value => value))
    def discoveredSlotTypeCount: Optional[Count]
    def getDiscoveredSlotTypeCount: ZIO[Any, AwsError, Count] = AwsError
      .unwrapOptionField("discoveredSlotTypeCount", discoveredSlotTypeCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeStatistics
  ) extends zio.aws.lexmodelsv2.model.SlotTypeStatistics.ReadOnly {
    override val discoveredSlotTypeCount: Optional[Count] =
      zio.aws.core.internal
        .optionalFromNullable(impl.discoveredSlotTypeCount())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Count(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeStatistics
  ): zio.aws.lexmodelsv2.model.SlotTypeStatistics.ReadOnly = new Wrapper(impl)
}
