package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PostFulfillmentStatusSpecification(
    successResponse: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent,
    failureResponse: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent,
    timeoutResponse: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.PostFulfillmentStatusSpecification = {
    import PostFulfillmentStatusSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.PostFulfillmentStatusSpecification
      .builder()
      .optionallyWith(successResponse.map(value => value.buildAwsValue()))(
        _.successResponse
      )
      .optionallyWith(failureResponse.map(value => value.buildAwsValue()))(
        _.failureResponse
      )
      .optionallyWith(timeoutResponse.map(value => value.buildAwsValue()))(
        _.timeoutResponse
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification
      .wrap(buildAwsValue())
}
object PostFulfillmentStatusSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.PostFulfillmentStatusSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification =
      zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification(
        successResponse.map(value => value.asEditable),
        failureResponse.map(value => value.asEditable),
        timeoutResponse.map(value => value.asEditable)
      )
    def successResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def failureResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def timeoutResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def getSuccessResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("successResponse", successResponse)
    def getFailureResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("failureResponse", failureResponse)
    def getTimeoutResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("timeoutResponse", timeoutResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PostFulfillmentStatusSpecification
  ) extends zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.ReadOnly {
    override val successResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
    override val failureResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
    override val timeoutResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PostFulfillmentStatusSpecification
  ): zio.aws.lexmodelsv2.model.PostFulfillmentStatusSpecification.ReadOnly =
    new Wrapper(impl)
}
