package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IntentClosingSetting(
    closingResponse: zio.aws.lexmodelsv2.model.ResponseSpecification,
    active: Optional[BoxedBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentClosingSetting = {
    import IntentClosingSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentClosingSetting
      .builder()
      .closingResponse(closingResponse.buildAwsValue())
      .optionallyWith(active.map(value => value: java.lang.Boolean))(_.active)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.IntentClosingSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentClosingSetting.wrap(buildAwsValue())
}
object IntentClosingSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentClosingSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.IntentClosingSetting =
      zio.aws.lexmodelsv2.model.IntentClosingSetting(
        closingResponse.asEditable,
        active.map(value => value)
      )
    def closingResponse
        : zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    def active: Optional[BoxedBoolean]
    def getClosingResponse: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = ZIO.succeed(closingResponse)
    def getActive: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("active", active)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentClosingSetting
  ) extends zio.aws.lexmodelsv2.model.IntentClosingSetting.ReadOnly {
    override val closingResponse
        : zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.ResponseSpecification
        .wrap(impl.closingResponse())
    override val active: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.active())
      .map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentClosingSetting
  ): zio.aws.lexmodelsv2.model.IntentClosingSetting.ReadOnly = new Wrapper(impl)
}
