package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait SlotConstraint {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint
}
object SlotConstraint {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint
  ): zio.aws.lexmodelsv2.model.SlotConstraint = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint.REQUIRED =>
      val r = Required
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint.OPTIONAL =>
      val r = Optional
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.SlotConstraint {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint.UNKNOWN_TO_SDK_VERSION
  }
  case object Required extends zio.aws.lexmodelsv2.model.SlotConstraint {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint.REQUIRED
  }
  case object Optional extends zio.aws.lexmodelsv2.model.SlotConstraint {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint.OPTIONAL
  }
}
