package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, BotVersion, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeSlotRequest(
    slotId: Id,
    botId: Id,
    botVersion: BotVersion,
    localeId: LocaleId,
    intentId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest = {
    import DescribeSlotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest
      .builder()
      .slotId(Id.unwrap(slotId): java.lang.String)
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(BotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .intentId(Id.unwrap(intentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeSlotRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeSlotRequest.wrap(buildAwsValue())
}
object DescribeSlotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeSlotRequest =
      zio.aws.lexmodelsv2.model.DescribeSlotRequest(
        slotId,
        botId,
        botVersion,
        localeId,
        intentId
      )
    def slotId: Id
    def botId: Id
    def botVersion: BotVersion
    def localeId: LocaleId
    def intentId: Id
    def getSlotId: ZIO[Any, Nothing, Id] = ZIO.succeed(slotId)
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, BotVersion] = ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getIntentId: ZIO[Any, Nothing, Id] = ZIO.succeed(intentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest
  ) extends zio.aws.lexmodelsv2.model.DescribeSlotRequest.ReadOnly {
    override val slotId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.slotId())
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: BotVersion =
      zio.aws.lexmodelsv2.model.primitives.BotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val intentId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.intentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest
  ): zio.aws.lexmodelsv2.model.DescribeSlotRequest.ReadOnly = new Wrapper(impl)
}
