package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{NumericalBotVersion, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBotVersionResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[NumericalBotVersion] = Optional.Absent,
    botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse = {
    import DeleteBotVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value =>
          NumericalBotVersion.unwrap(value): java.lang.String
        )
      )(_.botVersion)
      .optionallyWith(botStatus.map(value => value.unwrap))(_.botStatus)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.wrap(buildAwsValue())
}
object DeleteBotVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteBotVersionResponse =
      zio.aws.lexmodelsv2.model.DeleteBotVersionResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        botStatus.map(value => value)
      )
    def botId: Optional[Id]
    def botVersion: Optional[NumericalBotVersion]
    def botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, NumericalBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getBotStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotStatus] =
      AwsError.unwrapOptionField("botStatus", botStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse
  ) extends zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[NumericalBotVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botVersion())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.NumericalBotVersion(value)
        )
    override val botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botStatus())
        .map(value => zio.aws.lexmodelsv2.model.BotStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse
  ): zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
