package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  SkipResourceInUseCheck,
  NumericalBotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBotVersionRequest(
    botId: Id,
    botVersion: NumericalBotVersion,
    skipResourceInUseCheck: Optional[SkipResourceInUseCheck] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest = {
    import DeleteBotVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(NumericalBotVersion.unwrap(botVersion): java.lang.String)
      .optionallyWith(
        skipResourceInUseCheck.map(value =>
          SkipResourceInUseCheck.unwrap(value): java.lang.Boolean
        )
      )(_.skipResourceInUseCheck)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteBotVersionRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteBotVersionRequest.wrap(buildAwsValue())
}
object DeleteBotVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteBotVersionRequest =
      zio.aws.lexmodelsv2.model.DeleteBotVersionRequest(
        botId,
        botVersion,
        skipResourceInUseCheck.map(value => value)
      )
    def botId: Id
    def botVersion: NumericalBotVersion
    def skipResourceInUseCheck: Optional[SkipResourceInUseCheck]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, NumericalBotVersion] =
      ZIO.succeed(botVersion)
    def getSkipResourceInUseCheck: ZIO[Any, AwsError, SkipResourceInUseCheck] =
      AwsError.unwrapOptionField(
        "skipResourceInUseCheck",
        skipResourceInUseCheck
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteBotVersionRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: NumericalBotVersion =
      zio.aws.lexmodelsv2.model.primitives
        .NumericalBotVersion(impl.botVersion())
    override val skipResourceInUseCheck: Optional[SkipResourceInUseCheck] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skipResourceInUseCheck())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.SkipResourceInUseCheck(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest
  ): zio.aws.lexmodelsv2.model.DeleteBotVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
