package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  NextToken,
  DraftBotVersion,
  MaxResults,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRecommendedIntentsRequest(
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId,
    botRecommendationId: Id,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest = {
    import ListRecommendedIntentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .botRecommendationId(Id.unwrap(botRecommendationId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListRecommendedIntentsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListRecommendedIntentsRequest
      .wrap(buildAwsValue())
}
object ListRecommendedIntentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListRecommendedIntentsRequest =
      zio.aws.lexmodelsv2.model.ListRecommendedIntentsRequest(
        botId,
        botVersion,
        localeId,
        botRecommendationId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def botRecommendationId: Id
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getBotRecommendationId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(botRecommendationId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest
  ) extends zio.aws.lexmodelsv2.model.ListRecommendedIntentsRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val botRecommendationId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botRecommendationId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest
  ): zio.aws.lexmodelsv2.model.ListRecommendedIntentsRequest.ReadOnly =
    new Wrapper(impl)
}
