package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TranscriptFilter(
    lexTranscriptFilter: Optional[
      zio.aws.lexmodelsv2.model.LexTranscriptFilter
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFilter = {
    import TranscriptFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFilter
      .builder()
      .optionallyWith(lexTranscriptFilter.map(value => value.buildAwsValue()))(
        _.lexTranscriptFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TranscriptFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.TranscriptFilter.wrap(buildAwsValue())
}
object TranscriptFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TranscriptFilter =
      zio.aws.lexmodelsv2.model
        .TranscriptFilter(lexTranscriptFilter.map(value => value.asEditable))
    def lexTranscriptFilter
        : Optional[zio.aws.lexmodelsv2.model.LexTranscriptFilter.ReadOnly]
    def getLexTranscriptFilter: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.LexTranscriptFilter.ReadOnly
    ] = AwsError.unwrapOptionField("lexTranscriptFilter", lexTranscriptFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFilter
  ) extends zio.aws.lexmodelsv2.model.TranscriptFilter.ReadOnly {
    override val lexTranscriptFilter
        : Optional[zio.aws.lexmodelsv2.model.LexTranscriptFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lexTranscriptFilter())
        .map(value => zio.aws.lexmodelsv2.model.LexTranscriptFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFilter
  ): zio.aws.lexmodelsv2.model.TranscriptFilter.ReadOnly = new Wrapper(impl)
}
