package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  RecommendedAction,
  LocaleName,
  Timestamp,
  FailureReason,
  ConfidenceThreshold,
  ResourceCount,
  Description,
  BotVersion,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeBotLocaleResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    localeName: Optional[LocaleName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    nluIntentConfidenceThreshold: Optional[ConfidenceThreshold] =
      Optional.Absent,
    voiceSettings: Optional[zio.aws.lexmodelsv2.model.VoiceSettings] =
      Optional.Absent,
    intentsCount: Optional[ResourceCount] = Optional.Absent,
    slotTypesCount: Optional[ResourceCount] = Optional.Absent,
    botLocaleStatus: Optional[zio.aws.lexmodelsv2.model.BotLocaleStatus] =
      Optional.Absent,
    failureReasons: Optional[Iterable[FailureReason]] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent,
    lastBuildSubmittedDateTime: Optional[Timestamp] = Optional.Absent,
    botLocaleHistoryEvents: Optional[
      Iterable[zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent]
    ] = Optional.Absent,
    recommendedActions: Optional[Iterable[RecommendedAction]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse = {
    import DescribeBotLocaleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        localeName.map(value => LocaleName.unwrap(value): java.lang.String)
      )(_.localeName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        nluIntentConfidenceThreshold.map(value =>
          ConfidenceThreshold.unwrap(value): java.lang.Double
        )
      )(_.nluIntentConfidenceThreshold)
      .optionallyWith(voiceSettings.map(value => value.buildAwsValue()))(
        _.voiceSettings
      )
      .optionallyWith(
        intentsCount.map(value => ResourceCount.unwrap(value): Integer)
      )(_.intentsCount)
      .optionallyWith(
        slotTypesCount.map(value => ResourceCount.unwrap(value): Integer)
      )(_.slotTypesCount)
      .optionallyWith(botLocaleStatus.map(value => value.unwrap))(
        _.botLocaleStatus
      )
      .optionallyWith(
        failureReasons.map(value =>
          value.map { item =>
            FailureReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failureReasons)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        lastBuildSubmittedDateTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.lastBuildSubmittedDateTime)
      .optionallyWith(
        botLocaleHistoryEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botLocaleHistoryEvents)
      .optionallyWith(
        recommendedActions.map(value =>
          value.map { item =>
            RecommendedAction.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.recommendedActions)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.wrap(buildAwsValue())
}
object DescribeBotLocaleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse =
      zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        localeName.map(value => value),
        description.map(value => value),
        nluIntentConfidenceThreshold.map(value => value),
        voiceSettings.map(value => value.asEditable),
        intentsCount.map(value => value),
        slotTypesCount.map(value => value),
        botLocaleStatus.map(value => value),
        failureReasons.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        lastBuildSubmittedDateTime.map(value => value),
        botLocaleHistoryEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendedActions.map(value => value)
      )
    def botId: Optional[Id]
    def botVersion: Optional[BotVersion]
    def localeId: Optional[LocaleId]
    def localeName: Optional[LocaleName]
    def description: Optional[Description]
    def nluIntentConfidenceThreshold: Optional[ConfidenceThreshold]
    def voiceSettings
        : Optional[zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly]
    def intentsCount: Optional[ResourceCount]
    def slotTypesCount: Optional[ResourceCount]
    def botLocaleStatus: Optional[zio.aws.lexmodelsv2.model.BotLocaleStatus]
    def failureReasons: Optional[List[FailureReason]]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def lastBuildSubmittedDateTime: Optional[Timestamp]
    def botLocaleHistoryEvents: Optional[
      List[zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent.ReadOnly]
    ]
    def recommendedActions: Optional[List[RecommendedAction]]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getLocaleName: ZIO[Any, AwsError, LocaleName] =
      AwsError.unwrapOptionField("localeName", localeName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNluIntentConfidenceThreshold
        : ZIO[Any, AwsError, ConfidenceThreshold] = AwsError.unwrapOptionField(
      "nluIntentConfidenceThreshold",
      nluIntentConfidenceThreshold
    )
    def getVoiceSettings
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly] =
      AwsError.unwrapOptionField("voiceSettings", voiceSettings)
    def getIntentsCount: ZIO[Any, AwsError, ResourceCount] =
      AwsError.unwrapOptionField("intentsCount", intentsCount)
    def getSlotTypesCount: ZIO[Any, AwsError, ResourceCount] =
      AwsError.unwrapOptionField("slotTypesCount", slotTypesCount)
    def getBotLocaleStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotLocaleStatus] =
      AwsError.unwrapOptionField("botLocaleStatus", botLocaleStatus)
    def getFailureReasons: ZIO[Any, AwsError, List[FailureReason]] =
      AwsError.unwrapOptionField("failureReasons", failureReasons)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getLastBuildSubmittedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "lastBuildSubmittedDateTime",
        lastBuildSubmittedDateTime
      )
    def getBotLocaleHistoryEvents: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "botLocaleHistoryEvents",
      botLocaleHistoryEvents
    )
    def getRecommendedActions: ZIO[Any, AwsError, List[RecommendedAction]] =
      AwsError.unwrapOptionField("recommendedActions", recommendedActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val localeName: Optional[LocaleName] = zio.aws.core.internal
      .optionalFromNullable(impl.localeName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val nluIntentConfidenceThreshold: Optional[ConfidenceThreshold] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nluIntentConfidenceThreshold())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.ConfidenceThreshold(value)
        )
    override val voiceSettings
        : Optional[zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceSettings())
        .map(value => zio.aws.lexmodelsv2.model.VoiceSettings.wrap(value))
    override val intentsCount: Optional[ResourceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.intentsCount())
      .map(value => zio.aws.lexmodelsv2.model.primitives.ResourceCount(value))
    override val slotTypesCount: Optional[ResourceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.slotTypesCount())
      .map(value => zio.aws.lexmodelsv2.model.primitives.ResourceCount(value))
    override val botLocaleStatus
        : Optional[zio.aws.lexmodelsv2.model.BotLocaleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botLocaleStatus())
        .map(value => zio.aws.lexmodelsv2.model.BotLocaleStatus.wrap(value))
    override val failureReasons: Optional[List[FailureReason]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.primitives.FailureReason(item)
          }.toList
        )
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastBuildSubmittedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastBuildSubmittedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val botLocaleHistoryEvents: Optional[
      List[zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.botLocaleHistoryEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent.wrap(item)
        }.toList
      )
    override val recommendedActions: Optional[List[RecommendedAction]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendedActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.primitives.RecommendedAction(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse
  ): zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.ReadOnly = new Wrapper(
    impl
  )
}
