package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  ContextTurnsToLive,
  ContextTimeToLiveInSeconds,
  Name
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OutputContext(
    name: Name,
    timeToLiveInSeconds: ContextTimeToLiveInSeconds,
    turnsToLive: ContextTurnsToLive
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.OutputContext = {
    import OutputContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.OutputContext
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .timeToLiveInSeconds(
        ContextTimeToLiveInSeconds.unwrap(timeToLiveInSeconds): Integer
      )
      .turnsToLive(ContextTurnsToLive.unwrap(turnsToLive): Integer)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.OutputContext.ReadOnly =
    zio.aws.lexmodelsv2.model.OutputContext.wrap(buildAwsValue())
}
object OutputContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.OutputContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.OutputContext =
      zio.aws.lexmodelsv2.model
        .OutputContext(name, timeToLiveInSeconds, turnsToLive)
    def name: Name
    def timeToLiveInSeconds: ContextTimeToLiveInSeconds
    def turnsToLive: ContextTurnsToLive
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getTimeToLiveInSeconds: ZIO[Any, Nothing, ContextTimeToLiveInSeconds] =
      ZIO.succeed(timeToLiveInSeconds)
    def getTurnsToLive: ZIO[Any, Nothing, ContextTurnsToLive] =
      ZIO.succeed(turnsToLive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.OutputContext
  ) extends zio.aws.lexmodelsv2.model.OutputContext.ReadOnly {
    override val name: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.name())
    override val timeToLiveInSeconds: ContextTimeToLiveInSeconds =
      zio.aws.lexmodelsv2.model.primitives
        .ContextTimeToLiveInSeconds(impl.timeToLiveInSeconds())
    override val turnsToLive: ContextTurnsToLive =
      zio.aws.lexmodelsv2.model.primitives
        .ContextTurnsToLive(impl.turnsToLive())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.OutputContext
  ): zio.aws.lexmodelsv2.model.OutputContext.ReadOnly = new Wrapper(impl)
}
