package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait ImportStatus {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus
}
object ImportStatus {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus
  ): zio.aws.lexmodelsv2.model.ImportStatus = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus.DELETING =>
      val r = Deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.lexmodelsv2.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.lexmodelsv2.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus.COMPLETED
  }
  case object Failed extends zio.aws.lexmodelsv2.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus.FAILED
  }
  case object Deleting extends zio.aws.lexmodelsv2.model.ImportStatus {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportStatus.DELETING
  }
}
