package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, DraftBotVersion, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteIntentRequest(
    intentId: Id,
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest = {
    import DeleteIntentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest
      .builder()
      .intentId(Id.unwrap(intentId): java.lang.String)
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteIntentRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteIntentRequest.wrap(buildAwsValue())
}
object DeleteIntentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteIntentRequest =
      zio.aws.lexmodelsv2.model.DeleteIntentRequest(
        intentId,
        botId,
        botVersion,
        localeId
      )
    def intentId: Id
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def getIntentId: ZIO[Any, Nothing, Id] = ZIO.succeed(intentId)
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteIntentRequest.ReadOnly {
    override val intentId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.intentId())
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest
  ): zio.aws.lexmodelsv2.model.DeleteIntentRequest.ReadOnly = new Wrapper(impl)
}
