package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, BotVersion, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BotLocaleExportSpecification(
    botId: Id,
    botVersion: BotVersion,
    localeId: LocaleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleExportSpecification = {
    import BotLocaleExportSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleExportSpecification
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(BotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.BotLocaleExportSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.BotLocaleExportSpecification.wrap(buildAwsValue())
}
object BotLocaleExportSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleExportSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotLocaleExportSpecification =
      zio.aws.lexmodelsv2.model
        .BotLocaleExportSpecification(botId, botVersion, localeId)
    def botId: Id
    def botVersion: BotVersion
    def localeId: LocaleId
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, BotVersion] = ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleExportSpecification
  ) extends zio.aws.lexmodelsv2.model.BotLocaleExportSpecification.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: BotVersion =
      zio.aws.lexmodelsv2.model.primitives.BotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleExportSpecification
  ): zio.aws.lexmodelsv2.model.BotLocaleExportSpecification.ReadOnly =
    new Wrapper(impl)
}
