package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MultipleValuesSetting(
    allowMultipleValues: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.MultipleValuesSetting = {
    import MultipleValuesSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.MultipleValuesSetting
      .builder()
      .optionallyWith(
        allowMultipleValues.map(value => value: java.lang.Boolean)
      )(_.allowMultipleValues)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.MultipleValuesSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.MultipleValuesSetting.wrap(buildAwsValue())
}
object MultipleValuesSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.MultipleValuesSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.MultipleValuesSetting =
      zio.aws.lexmodelsv2.model
        .MultipleValuesSetting(allowMultipleValues.map(value => value))
    def allowMultipleValues: Optional[Boolean]
    def getAllowMultipleValues: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowMultipleValues", allowMultipleValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.MultipleValuesSetting
  ) extends zio.aws.lexmodelsv2.model.MultipleValuesSetting.ReadOnly {
    override val allowMultipleValues: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowMultipleValues())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.MultipleValuesSetting
  ): zio.aws.lexmodelsv2.model.MultipleValuesSetting.ReadOnly = new Wrapper(
    impl
  )
}
