package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{SessionId, LocaleId, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteUtterancesRequest(
    botId: Id,
    localeId: Optional[LocaleId] = Optional.Absent,
    sessionId: Optional[SessionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest = {
    import DeleteUtterancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteUtterancesRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteUtterancesRequest.wrap(buildAwsValue())
}
object DeleteUtterancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteUtterancesRequest =
      zio.aws.lexmodelsv2.model.DeleteUtterancesRequest(
        botId,
        localeId.map(value => value),
        sessionId.map(value => value)
      )
    def botId: Id
    def localeId: Optional[LocaleId]
    def sessionId: Optional[SessionId]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteUtterancesRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.SessionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest
  ): zio.aws.lexmodelsv2.model.DeleteUtterancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
