package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteExportResponse(
    exportId: Optional[Id] = Optional.Absent,
    exportStatus: Optional[zio.aws.lexmodelsv2.model.ExportStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportResponse = {
    import DeleteExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportResponse
      .builder()
      .optionallyWith(
        exportId.map(value => Id.unwrap(value): java.lang.String)
      )(_.exportId)
      .optionallyWith(exportStatus.map(value => value.unwrap))(_.exportStatus)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteExportResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteExportResponse.wrap(buildAwsValue())
}
object DeleteExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteExportResponse =
      zio.aws.lexmodelsv2.model.DeleteExportResponse(
        exportId.map(value => value),
        exportStatus.map(value => value)
      )
    def exportId: Optional[Id]
    def exportStatus: Optional[zio.aws.lexmodelsv2.model.ExportStatus]
    def getExportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("exportId", exportId)
    def getExportStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ExportStatus] =
      AwsError.unwrapOptionField("exportStatus", exportStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportResponse
  ) extends zio.aws.lexmodelsv2.model.DeleteExportResponse.ReadOnly {
    override val exportId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.exportId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val exportStatus
        : Optional[zio.aws.lexmodelsv2.model.ExportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportStatus())
        .map(value => zio.aws.lexmodelsv2.model.ExportStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportResponse
  ): zio.aws.lexmodelsv2.model.DeleteExportResponse.ReadOnly = new Wrapper(impl)
}
