package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.CustomPayloadValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CustomPayload(value: CustomPayloadValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CustomPayload = {
    import CustomPayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CustomPayload
      .builder()
      .value(CustomPayloadValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CustomPayload.ReadOnly =
    zio.aws.lexmodelsv2.model.CustomPayload.wrap(buildAwsValue())
}
object CustomPayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CustomPayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CustomPayload =
      zio.aws.lexmodelsv2.model.CustomPayload(value)
    def value: CustomPayloadValue
    def getValue: ZIO[Any, Nothing, CustomPayloadValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CustomPayload
  ) extends zio.aws.lexmodelsv2.model.CustomPayload.ReadOnly {
    override val value: CustomPayloadValue =
      zio.aws.lexmodelsv2.model.primitives.CustomPayloadValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CustomPayload
  ): zio.aws.lexmodelsv2.model.CustomPayload.ReadOnly = new Wrapper(impl)
}
