package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.BotVersion
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BotVersionLocaleDetails(sourceBotVersion: BotVersion) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotVersionLocaleDetails = {
    import BotVersionLocaleDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotVersionLocaleDetails
      .builder()
      .sourceBotVersion(BotVersion.unwrap(sourceBotVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotVersionLocaleDetails.ReadOnly =
    zio.aws.lexmodelsv2.model.BotVersionLocaleDetails.wrap(buildAwsValue())
}
object BotVersionLocaleDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotVersionLocaleDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotVersionLocaleDetails =
      zio.aws.lexmodelsv2.model.BotVersionLocaleDetails(sourceBotVersion)
    def sourceBotVersion: BotVersion
    def getSourceBotVersion: ZIO[Any, Nothing, BotVersion] =
      ZIO.succeed(sourceBotVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotVersionLocaleDetails
  ) extends zio.aws.lexmodelsv2.model.BotVersionLocaleDetails.ReadOnly {
    override val sourceBotVersion: BotVersion =
      zio.aws.lexmodelsv2.model.primitives.BotVersion(impl.sourceBotVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotVersionLocaleDetails
  ): zio.aws.lexmodelsv2.model.BotVersionLocaleDetails.ReadOnly = new Wrapper(
    impl
  )
}
