package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  Description,
  LocaleName,
  LocaleId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class BotLocaleSummary(
    localeId: Option[LocaleId] = None,
    localeName: Option[LocaleName] = None,
    description: Option[Description] = None,
    botLocaleStatus: Option[zio.aws.lexmodelsv2.model.BotLocaleStatus] = None,
    lastUpdatedDateTime: Option[Timestamp] = None,
    lastBuildSubmittedDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleSummary = {
    import BotLocaleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleSummary
      .builder()
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        localeName.map(value => LocaleName.unwrap(value): java.lang.String)
      )(_.localeName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(botLocaleStatus.map(value => value.unwrap))(
        _.botLocaleStatus
      )
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        lastBuildSubmittedDateTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.lastBuildSubmittedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotLocaleSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.BotLocaleSummary.wrap(buildAwsValue())
}
object BotLocaleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotLocaleSummary =
      zio.aws.lexmodelsv2.model.BotLocaleSummary(
        localeId.map(value => value),
        localeName.map(value => value),
        description.map(value => value),
        botLocaleStatus.map(value => value),
        lastUpdatedDateTime.map(value => value),
        lastBuildSubmittedDateTime.map(value => value)
      )
    def localeId: Option[LocaleId]
    def localeName: Option[LocaleName]
    def description: Option[Description]
    def botLocaleStatus: Option[zio.aws.lexmodelsv2.model.BotLocaleStatus]
    def lastUpdatedDateTime: Option[Timestamp]
    def lastBuildSubmittedDateTime: Option[Timestamp]
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getLocaleName: ZIO[Any, AwsError, LocaleName] =
      AwsError.unwrapOptionField("localeName", localeName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotLocaleStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotLocaleStatus] =
      AwsError.unwrapOptionField("botLocaleStatus", botLocaleStatus)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getLastBuildSubmittedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "lastBuildSubmittedDateTime",
        lastBuildSubmittedDateTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleSummary
  ) extends zio.aws.lexmodelsv2.model.BotLocaleSummary.ReadOnly {
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val localeName: Option[LocaleName] = scala
      .Option(impl.localeName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botLocaleStatus
        : Option[zio.aws.lexmodelsv2.model.BotLocaleStatus] = scala
      .Option(impl.botLocaleStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotLocaleStatus.wrap(value))
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastBuildSubmittedDateTime: Option[Timestamp] = scala
      .Option(impl.lastBuildSubmittedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleSummary
  ): zio.aws.lexmodelsv2.model.BotLocaleSummary.ReadOnly = new Wrapper(impl)
}
