package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  BotLocaleHistoryEventDescription
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class BotLocaleHistoryEvent(
    event: BotLocaleHistoryEventDescription,
    eventDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleHistoryEvent = {
    import BotLocaleHistoryEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleHistoryEvent
      .builder()
      .event(BotLocaleHistoryEventDescription.unwrap(event): java.lang.String)
      .eventDate(Timestamp.unwrap(eventDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent.ReadOnly =
    zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent.wrap(buildAwsValue())
}
object BotLocaleHistoryEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleHistoryEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent =
      zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent(event, eventDate)
    def event: BotLocaleHistoryEventDescription
    def eventDate: Timestamp
    def getEvent: ZIO[Any, Nothing, BotLocaleHistoryEventDescription] =
      ZIO.succeed(event)
    def getEventDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(eventDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleHistoryEvent
  ) extends zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent.ReadOnly {
    override val event: BotLocaleHistoryEventDescription =
      zio.aws.lexmodelsv2.model.primitives
        .BotLocaleHistoryEventDescription(impl.event())
    override val eventDate: Timestamp =
      zio.aws.lexmodelsv2.model.primitives.Timestamp(impl.eventDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleHistoryEvent
  ): zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent.ReadOnly = new Wrapper(
    impl
  )
}
