package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, DraftBotVersion, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartBotRecommendationRequest(
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId,
    transcriptSourceSetting: zio.aws.lexmodelsv2.model.TranscriptSourceSetting,
    encryptionSetting: Option[zio.aws.lexmodelsv2.model.EncryptionSetting] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationRequest = {
    import StartBotRecommendationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .transcriptSourceSetting(transcriptSourceSetting.buildAwsValue())
      .optionallyWith(encryptionSetting.map(value => value.buildAwsValue()))(
        _.encryptionSetting
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.StartBotRecommendationRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.StartBotRecommendationRequest
      .wrap(buildAwsValue())
}
object StartBotRecommendationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.StartBotRecommendationRequest =
      zio.aws.lexmodelsv2.model.StartBotRecommendationRequest(
        botId,
        botVersion,
        localeId,
        transcriptSourceSetting.asEditable,
        encryptionSetting.map(value => value.asEditable)
      )
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def transcriptSourceSetting
        : zio.aws.lexmodelsv2.model.TranscriptSourceSetting.ReadOnly
    def encryptionSetting
        : Option[zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getTranscriptSourceSetting: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.TranscriptSourceSetting.ReadOnly
    ] = ZIO.succeed(transcriptSourceSetting)
    def getEncryptionSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly
    ] = AwsError.unwrapOptionField("encryptionSetting", encryptionSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationRequest
  ) extends zio.aws.lexmodelsv2.model.StartBotRecommendationRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val transcriptSourceSetting
        : zio.aws.lexmodelsv2.model.TranscriptSourceSetting.ReadOnly =
      zio.aws.lexmodelsv2.model.TranscriptSourceSetting
        .wrap(impl.transcriptSourceSetting())
    override val encryptionSetting
        : Option[zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly] = scala
      .Option(impl.encryptionSetting())
      .map(value => zio.aws.lexmodelsv2.model.EncryptionSetting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartBotRecommendationRequest
  ): zio.aws.lexmodelsv2.model.StartBotRecommendationRequest.ReadOnly =
    new Wrapper(impl)
}
