package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IntentSortBy(
    attribute: zio.aws.lexmodelsv2.model.IntentSortAttribute,
    order: zio.aws.lexmodelsv2.model.SortOrder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentSortBy = {
    import IntentSortBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentSortBy
      .builder()
      .attribute(attribute.unwrap)
      .order(order.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.IntentSortBy.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentSortBy.wrap(buildAwsValue())
}
object IntentSortBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentSortBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.IntentSortBy =
      zio.aws.lexmodelsv2.model.IntentSortBy(attribute, order)
    def attribute: zio.aws.lexmodelsv2.model.IntentSortAttribute
    def order: zio.aws.lexmodelsv2.model.SortOrder
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.IntentSortAttribute] =
      ZIO.succeed(attribute)
    def getOrder: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SortOrder] =
      ZIO.succeed(order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentSortBy
  ) extends zio.aws.lexmodelsv2.model.IntentSortBy.ReadOnly {
    override val attribute: zio.aws.lexmodelsv2.model.IntentSortAttribute =
      zio.aws.lexmodelsv2.model.IntentSortAttribute.wrap(impl.attribute())
    override val order: zio.aws.lexmodelsv2.model.SortOrder =
      zio.aws.lexmodelsv2.model.SortOrder.wrap(impl.order())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentSortBy
  ): zio.aws.lexmodelsv2.model.IntentSortBy.ReadOnly = new Wrapper(impl)
}
