package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Policy, AmazonResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateResourcePolicyRequest(
    resourceArn: AmazonResourceName,
    policy: Policy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyRequest = {
    import CreateResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .policy(Policy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.CreateResourcePolicyRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateResourcePolicyRequest.wrap(buildAwsValue())
}
object CreateResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateResourcePolicyRequest =
      zio.aws.lexmodelsv2.model.CreateResourcePolicyRequest(resourceArn, policy)
    def resourceArn: AmazonResourceName
    def policy: Policy
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyRequest
  ) extends zio.aws.lexmodelsv2.model.CreateResourcePolicyRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.lexmodelsv2.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val policy: Policy =
      zio.aws.lexmodelsv2.model.primitives.Policy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyRequest
  ): zio.aws.lexmodelsv2.model.CreateResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
