package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, DraftBotVersion, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeBotRecommendationRequest(
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId,
    botRecommendationId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationRequest = {
    import DescribeBotRecommendationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .botRecommendationId(Id.unwrap(botRecommendationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DescribeBotRecommendationRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeBotRecommendationRequest
      .wrap(buildAwsValue())
}
object DescribeBotRecommendationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeBotRecommendationRequest =
      zio.aws.lexmodelsv2.model.DescribeBotRecommendationRequest(
        botId,
        botVersion,
        localeId,
        botRecommendationId
      )
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def botRecommendationId: Id
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getBotRecommendationId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(botRecommendationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationRequest
  ) extends zio.aws.lexmodelsv2.model.DescribeBotRecommendationRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val botRecommendationId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botRecommendationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRecommendationRequest
  ): zio.aws.lexmodelsv2.model.DescribeBotRecommendationRequest.ReadOnly =
    new Wrapper(impl)
}
