package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Timestamp, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateExportResponse(
    exportId: Option[Id] = None,
    resourceSpecification: Option[
      zio.aws.lexmodelsv2.model.ExportResourceSpecification
    ] = None,
    fileFormat: Option[zio.aws.lexmodelsv2.model.ImportExportFileFormat] = None,
    exportStatus: Option[zio.aws.lexmodelsv2.model.ExportStatus] = None,
    creationDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse = {
    import CreateExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse
      .builder()
      .optionallyWith(
        exportId.map(value => Id.unwrap(value): java.lang.String)
      )(_.exportId)
      .optionallyWith(
        resourceSpecification.map(value => value.buildAwsValue())
      )(_.resourceSpecification)
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(exportStatus.map(value => value.unwrap))(_.exportStatus)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateExportResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateExportResponse.wrap(buildAwsValue())
}
object CreateExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateExportResponse =
      zio.aws.lexmodelsv2.model.CreateExportResponse(
        exportId.map(value => value),
        resourceSpecification.map(value => value.asEditable),
        fileFormat.map(value => value),
        exportStatus.map(value => value),
        creationDateTime.map(value => value)
      )
    def exportId: Option[Id]
    def resourceSpecification
        : Option[zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly]
    def fileFormat: Option[zio.aws.lexmodelsv2.model.ImportExportFileFormat]
    def exportStatus: Option[zio.aws.lexmodelsv2.model.ExportStatus]
    def creationDateTime: Option[Timestamp]
    def getExportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("exportId", exportId)
    def getResourceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("resourceSpecification", resourceSpecification)
    def getFileFormat
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ImportExportFileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getExportStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ExportStatus] =
      AwsError.unwrapOptionField("exportStatus", exportStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse
  ) extends zio.aws.lexmodelsv2.model.CreateExportResponse.ReadOnly {
    override val exportId: Option[Id] = scala
      .Option(impl.exportId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val resourceSpecification: Option[
      zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly
    ] = scala
      .Option(impl.resourceSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.ExportResourceSpecification.wrap(value)
      )
    override val fileFormat
        : Option[zio.aws.lexmodelsv2.model.ImportExportFileFormat] = scala
      .Option(impl.fileFormat())
      .map(value =>
        zio.aws.lexmodelsv2.model.ImportExportFileFormat.wrap(value)
      )
    override val exportStatus: Option[zio.aws.lexmodelsv2.model.ExportStatus] =
      scala
        .Option(impl.exportStatus())
        .map(value => zio.aws.lexmodelsv2.model.ExportStatus.wrap(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse
  ): zio.aws.lexmodelsv2.model.CreateExportResponse.ReadOnly = new Wrapper(impl)
}
