package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  RoleArn,
  Timestamp,
  FailureReason,
  SessionTTL,
  NumericalBotVersion,
  Description,
  Name,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeBotVersionResponse(
    botId: Option[Id] = None,
    botName: Option[Name] = None,
    botVersion: Option[NumericalBotVersion] = None,
    description: Option[Description] = None,
    roleArn: Option[RoleArn] = None,
    dataPrivacy: Option[zio.aws.lexmodelsv2.model.DataPrivacy] = None,
    idleSessionTTLInSeconds: Option[SessionTTL] = None,
    botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus] = None,
    failureReasons: Option[Iterable[FailureReason]] = None,
    creationDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse = {
    import DescribeBotVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botName)
      .optionallyWith(
        botVersion.map(value =>
          NumericalBotVersion.unwrap(value): java.lang.String
        )
      )(_.botVersion)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(dataPrivacy.map(value => value.buildAwsValue()))(
        _.dataPrivacy
      )
      .optionallyWith(
        idleSessionTTLInSeconds.map(value => SessionTTL.unwrap(value): Integer)
      )(_.idleSessionTTLInSeconds)
      .optionallyWith(botStatus.map(value => value.unwrap))(_.botStatus)
      .optionallyWith(
        failureReasons.map(value =>
          value.map { item =>
            FailureReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failureReasons)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DescribeBotVersionResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeBotVersionResponse.wrap(buildAwsValue())
}
object DescribeBotVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeBotVersionResponse =
      zio.aws.lexmodelsv2.model.DescribeBotVersionResponse(
        botId.map(value => value),
        botName.map(value => value),
        botVersion.map(value => value),
        description.map(value => value),
        roleArn.map(value => value),
        dataPrivacy.map(value => value.asEditable),
        idleSessionTTLInSeconds.map(value => value),
        botStatus.map(value => value),
        failureReasons.map(value => value),
        creationDateTime.map(value => value)
      )
    def botId: Option[Id]
    def botName: Option[Name]
    def botVersion: Option[NumericalBotVersion]
    def description: Option[Description]
    def roleArn: Option[RoleArn]
    def dataPrivacy: Option[zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly]
    def idleSessionTTLInSeconds: Option[SessionTTL]
    def botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus]
    def failureReasons: Option[List[FailureReason]]
    def creationDateTime: Option[Timestamp]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botName", botName)
    def getBotVersion: ZIO[Any, AwsError, NumericalBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDataPrivacy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly] =
      AwsError.unwrapOptionField("dataPrivacy", dataPrivacy)
    def getIdleSessionTTLInSeconds: ZIO[Any, AwsError, SessionTTL] = AwsError
      .unwrapOptionField("idleSessionTTLInSeconds", idleSessionTTLInSeconds)
    def getBotStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotStatus] =
      AwsError.unwrapOptionField("botStatus", botStatus)
    def getFailureReasons: ZIO[Any, AwsError, List[FailureReason]] =
      AwsError.unwrapOptionField("failureReasons", failureReasons)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeBotVersionResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botName: Option[Name] = scala
      .Option(impl.botName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val botVersion: Option[NumericalBotVersion] = scala
      .Option(impl.botVersion())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.NumericalBotVersion(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RoleArn(value))
    override val dataPrivacy
        : Option[zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly] = scala
      .Option(impl.dataPrivacy())
      .map(value => zio.aws.lexmodelsv2.model.DataPrivacy.wrap(value))
    override val idleSessionTTLInSeconds: Option[SessionTTL] = scala
      .Option(impl.idleSessionTTLInSeconds())
      .map(value => zio.aws.lexmodelsv2.model.primitives.SessionTTL(value))
    override val botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus] = scala
      .Option(impl.botStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotStatus.wrap(value))
    override val failureReasons: Option[List[FailureReason]] = scala
      .Option(impl.failureReasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.primitives.FailureReason(item)
        }.toList
      )
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse
  ): zio.aws.lexmodelsv2.model.DescribeBotVersionResponse.ReadOnly =
    new Wrapper(impl)
}
