package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, DraftBotVersion, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteBotLocaleResponse(
    botId: Option[Id] = None,
    botVersion: Option[DraftBotVersion] = None,
    localeId: Option[LocaleId] = None,
    botLocaleStatus: Option[zio.aws.lexmodelsv2.model.BotLocaleStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse = {
    import DeleteBotLocaleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(botLocaleStatus.map(value => value.unwrap))(
        _.botLocaleStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteBotLocaleResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteBotLocaleResponse.wrap(buildAwsValue())
}
object DeleteBotLocaleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteBotLocaleResponse =
      zio.aws.lexmodelsv2.model.DeleteBotLocaleResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        botLocaleStatus.map(value => value)
      )
    def botId: Option[Id]
    def botVersion: Option[DraftBotVersion]
    def localeId: Option[LocaleId]
    def botLocaleStatus: Option[zio.aws.lexmodelsv2.model.BotLocaleStatus]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getBotLocaleStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotLocaleStatus] =
      AwsError.unwrapOptionField("botLocaleStatus", botLocaleStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse
  ) extends zio.aws.lexmodelsv2.model.DeleteBotLocaleResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[DraftBotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val botLocaleStatus
        : Option[zio.aws.lexmodelsv2.model.BotLocaleStatus] = scala
      .Option(impl.botLocaleStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotLocaleStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse
  ): zio.aws.lexmodelsv2.model.DeleteBotLocaleResponse.ReadOnly = new Wrapper(
    impl
  )
}
