package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{QueryFilterString, KendraIndexArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KendraConfiguration(
    kendraIndex: KendraIndexArn,
    queryFilterStringEnabled: Option[Boolean] = None,
    queryFilterString: Option[QueryFilterString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.KendraConfiguration = {
    import KendraConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.KendraConfiguration
      .builder()
      .kendraIndex(KendraIndexArn.unwrap(kendraIndex): java.lang.String)
      .optionallyWith(
        queryFilterStringEnabled.map(value => value: java.lang.Boolean)
      )(_.queryFilterStringEnabled)
      .optionallyWith(
        queryFilterString.map(value =>
          QueryFilterString.unwrap(value): java.lang.String
        )
      )(_.queryFilterString)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.KendraConfiguration.ReadOnly =
    zio.aws.lexmodelsv2.model.KendraConfiguration.wrap(buildAwsValue())
}
object KendraConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.KendraConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.KendraConfiguration =
      zio.aws.lexmodelsv2.model.KendraConfiguration(
        kendraIndex,
        queryFilterStringEnabled.map(value => value),
        queryFilterString.map(value => value)
      )
    def kendraIndex: KendraIndexArn
    def queryFilterStringEnabled: Option[Boolean]
    def queryFilterString: Option[QueryFilterString]
    def getKendraIndex: ZIO[Any, Nothing, KendraIndexArn] =
      ZIO.succeed(kendraIndex)
    def getQueryFilterStringEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("queryFilterStringEnabled", queryFilterStringEnabled)
    def getQueryFilterString: ZIO[Any, AwsError, QueryFilterString] =
      AwsError.unwrapOptionField("queryFilterString", queryFilterString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.KendraConfiguration
  ) extends zio.aws.lexmodelsv2.model.KendraConfiguration.ReadOnly {
    override val kendraIndex: KendraIndexArn =
      zio.aws.lexmodelsv2.model.primitives.KendraIndexArn(impl.kendraIndex())
    override val queryFilterStringEnabled: Option[Boolean] =
      scala.Option(impl.queryFilterStringEnabled()).map(value => value: Boolean)
    override val queryFilterString: Option[QueryFilterString] = scala
      .Option(impl.queryFilterString())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.QueryFilterString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.KendraConfiguration
  ): zio.aws.lexmodelsv2.model.KendraConfiguration.ReadOnly = new Wrapper(impl)
}
