package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Id, BotAliasId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeBotAliasRequest(botAliasId: BotAliasId, botId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest = {
    import DescribeBotAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest
      .builder()
      .botAliasId(BotAliasId.unwrap(botAliasId): java.lang.String)
      .botId(Id.unwrap(botId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeBotAliasRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeBotAliasRequest.wrap(buildAwsValue())
}
object DescribeBotAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeBotAliasRequest =
      zio.aws.lexmodelsv2.model.DescribeBotAliasRequest(botAliasId, botId)
    def botAliasId: BotAliasId
    def botId: Id
    def getBotAliasId: ZIO[Any, Nothing, BotAliasId] = ZIO.succeed(botAliasId)
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest
  ) extends zio.aws.lexmodelsv2.model.DescribeBotAliasRequest.ReadOnly {
    override val botAliasId: BotAliasId =
      zio.aws.lexmodelsv2.model.primitives.BotAliasId(impl.botAliasId())
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest
  ): zio.aws.lexmodelsv2.model.DescribeBotAliasRequest.ReadOnly = new Wrapper(
    impl
  )
}
