package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.FilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SlotTypeFilter(
    name: zio.aws.lexmodelsv2.model.SlotTypeFilterName,
    values: Iterable[FilterValue],
    operator: zio.aws.lexmodelsv2.model.SlotTypeFilterOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilter = {
    import SlotTypeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotTypeFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotTypeFilter.wrap(buildAwsValue())
}
object SlotTypeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotTypeFilter =
      zio.aws.lexmodelsv2.model.SlotTypeFilter(name, values, operator)
    def name: zio.aws.lexmodelsv2.model.SlotTypeFilterName
    def values: List[FilterValue]
    def operator: zio.aws.lexmodelsv2.model.SlotTypeFilterOperator
    def getName
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SlotTypeFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SlotTypeFilterOperator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilter
  ) extends zio.aws.lexmodelsv2.model.SlotTypeFilter.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.SlotTypeFilterName =
      zio.aws.lexmodelsv2.model.SlotTypeFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.primitives.FilterValue(item)
      }
      .toList
    override val operator: zio.aws.lexmodelsv2.model.SlotTypeFilterOperator =
      zio.aws.lexmodelsv2.model.SlotTypeFilterOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilter
  ): zio.aws.lexmodelsv2.model.SlotTypeFilter.ReadOnly = new Wrapper(impl)
}
