package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  LocaleId,
  BotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListIntentsResponse(
    botId: Option[Id] = None,
    botVersion: Option[BotVersion] = None,
    localeId: Option[LocaleId] = None,
    intentSummaries: Option[Iterable[zio.aws.lexmodelsv2.model.IntentSummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse = {
    import ListIntentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        intentSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.intentSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListIntentsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListIntentsResponse.wrap(buildAwsValue())
}
object ListIntentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListIntentsResponse =
      zio.aws.lexmodelsv2.model.ListIntentsResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        intentSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botId: Option[Id]
    def botVersion: Option[BotVersion]
    def localeId: Option[LocaleId]
    def intentSummaries
        : Option[List[zio.aws.lexmodelsv2.model.IntentSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getIntentSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.IntentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("intentSummaries", intentSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse
  ) extends zio.aws.lexmodelsv2.model.ListIntentsResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val intentSummaries
        : Option[List[zio.aws.lexmodelsv2.model.IntentSummary.ReadOnly]] = scala
      .Option(impl.intentSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.IntentSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse
  ): zio.aws.lexmodelsv2.model.ListIntentsResponse.ReadOnly = new Wrapper(impl)
}
