package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{NextToken, BotVersion, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBotLocalesResponse(
    botId: Option[Id] = None,
    botVersion: Option[BotVersion] = None,
    nextToken: Option[NextToken] = None,
    botLocaleSummaries: Option[
      Iterable[zio.aws.lexmodelsv2.model.BotLocaleSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse = {
    import ListBotLocalesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        botLocaleSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botLocaleSummaries)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListBotLocalesResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBotLocalesResponse.wrap(buildAwsValue())
}
object ListBotLocalesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBotLocalesResponse =
      zio.aws.lexmodelsv2.model.ListBotLocalesResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        nextToken.map(value => value),
        botLocaleSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def botId: Option[Id]
    def botVersion: Option[BotVersion]
    def nextToken: Option[NextToken]
    def botLocaleSummaries
        : Option[List[zio.aws.lexmodelsv2.model.BotLocaleSummary.ReadOnly]]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBotLocaleSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotLocaleSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("botLocaleSummaries", botLocaleSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse
  ) extends zio.aws.lexmodelsv2.model.ListBotLocalesResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val botLocaleSummaries
        : Option[List[zio.aws.lexmodelsv2.model.BotLocaleSummary.ReadOnly]] =
      scala
        .Option(impl.botLocaleSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.BotLocaleSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse
  ): zio.aws.lexmodelsv2.model.ListBotLocalesResponse.ReadOnly = new Wrapper(
    impl
  )
}
