package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  RevisionId,
  Policy,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeResourcePolicyResponse(
    resourceArn: Option[AmazonResourceName] = None,
    policy: Option[Policy] = None,
    revisionId: Option[RevisionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyResponse = {
    import DescribeResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyResponse
      .builder()
      .optionallyWith(
        resourceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.resourceArn)
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DescribeResourcePolicyResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeResourcePolicyResponse
      .wrap(buildAwsValue())
}
object DescribeResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeResourcePolicyResponse =
      zio.aws.lexmodelsv2.model.DescribeResourcePolicyResponse(
        resourceArn.map(value => value),
        policy.map(value => value),
        revisionId.map(value => value)
      )
    def resourceArn: Option[AmazonResourceName]
    def policy: Option[Policy]
    def revisionId: Option[RevisionId]
    def getResourceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeResourcePolicyResponse.ReadOnly {
    override val resourceArn: Option[AmazonResourceName] = scala
      .Option(impl.resourceArn())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AmazonResourceName(value)
      )
    override val policy: Option[Policy] = scala
      .Option(impl.policy())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Policy(value))
    override val revisionId: Option[RevisionId] = scala
      .Option(impl.revisionId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyResponse
  ): zio.aws.lexmodelsv2.model.DescribeResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
