package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  LocaleId,
  DraftBotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class BuildBotLocaleResponse(
    botId: Option[Id] = None,
    botVersion: Option[DraftBotVersion] = None,
    localeId: Option[LocaleId] = None,
    botLocaleStatus: Option[zio.aws.lexmodelsv2.model.BotLocaleStatus] = None,
    lastBuildSubmittedDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse = {
    import BuildBotLocaleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(botLocaleStatus.map(value => value.unwrap))(
        _.botLocaleStatus
      )
      .optionallyWith(
        lastBuildSubmittedDateTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.lastBuildSubmittedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BuildBotLocaleResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.BuildBotLocaleResponse.wrap(buildAwsValue())
}
object BuildBotLocaleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BuildBotLocaleResponse =
      zio.aws.lexmodelsv2.model.BuildBotLocaleResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        botLocaleStatus.map(value => value),
        lastBuildSubmittedDateTime.map(value => value)
      )
    def botId: Option[Id]
    def botVersion: Option[DraftBotVersion]
    def localeId: Option[LocaleId]
    def botLocaleStatus: Option[zio.aws.lexmodelsv2.model.BotLocaleStatus]
    def lastBuildSubmittedDateTime: Option[Timestamp]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getBotLocaleStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotLocaleStatus] =
      AwsError.unwrapOptionField("botLocaleStatus", botLocaleStatus)
    def getLastBuildSubmittedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "lastBuildSubmittedDateTime",
        lastBuildSubmittedDateTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse
  ) extends zio.aws.lexmodelsv2.model.BuildBotLocaleResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[DraftBotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val botLocaleStatus
        : Option[zio.aws.lexmodelsv2.model.BotLocaleStatus] = scala
      .Option(impl.botLocaleStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotLocaleStatus.wrap(value))
    override val lastBuildSubmittedDateTime: Option[Timestamp] = scala
      .Option(impl.lastBuildSubmittedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse
  ): zio.aws.lexmodelsv2.model.BuildBotLocaleResponse.ReadOnly = new Wrapper(
    impl
  )
}
